/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionObject
extends BaseFunction {
    static final long serialVersionUID = -5332312783643935019L;
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    public static final int JAVA_UNSUPPORTED_TYPE = 0;
    public static final int JAVA_STRING_TYPE = 1;
    public static final int JAVA_INT_TYPE = 2;
    public static final int JAVA_BOOLEAN_TYPE = 3;
    public static final int JAVA_DOUBLE_TYPE = 4;
    public static final int JAVA_SCRIPTABLE_TYPE = 5;
    public static final int JAVA_OBJECT_TYPE = 6;
    MemberBox member;
    private String functionName;
    private transient byte[] typeTags;
    private int parmsLength;
    private transient boolean hasVoidReturn;
    private transient int returnTypeTag;
    private boolean isStatic;

    public FunctionObject(String name, Member methodOrConstructor, Scriptable scope) {
        if (methodOrConstructor instanceof Constructor) {
            this.member = new MemberBox((Constructor)methodOrConstructor);
            this.isStatic = true;
        } else {
            this.member = new MemberBox((Method)methodOrConstructor);
            this.isStatic = this.member.isStatic();
        }
        String methodName = this.member.getName();
        this.functionName = name;
        Class<?>[] types2 = this.member.argTypes;
        int arity = types2.length;
        if (arity == 4 && (types2[1].isArray() || types2[2].isArray())) {
            if (types2[1].isArray()) {
                if (!this.isStatic || types2[0] != ScriptRuntime.ContextClass || types2[1].getComponentType() != ScriptRuntime.ObjectClass || types2[2] != ScriptRuntime.FunctionClass || types2[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", methodName);
                }
                this.parmsLength = -2;
            } else {
                if (!this.isStatic || types2[0] != ScriptRuntime.ContextClass || types2[1] != ScriptRuntime.ScriptableClass || types2[2].getComponentType() != ScriptRuntime.ObjectClass || types2[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", methodName);
                }
                this.parmsLength = -1;
            }
        } else {
            this.parmsLength = arity;
            if (arity > 0) {
                this.typeTags = new byte[arity];
                for (int i = 0; i != arity; ++i) {
                    int tag = FunctionObject.getTypeTag(types2[i]);
                    if (tag == 0) {
                        throw Context.reportRuntimeError2("msg.bad.parms", types2[i].getName(), methodName);
                    }
                    this.typeTags[i] = (byte)tag;
                }
            }
        }
        if (this.member.isMethod()) {
            Method method2 = this.member.method();
            Class<?> returnType = method2.getReturnType();
            if (returnType == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                this.returnTypeTag = FunctionObject.getTypeTag(returnType);
            }
        } else {
            Class<?> ctorType = this.member.getDeclaringClass();
            if (!ScriptRuntime.ScriptableClass.isAssignableFrom(ctorType)) {
                throw Context.reportRuntimeError1("msg.bad.ctor.return", ctorType.getName());
            }
        }
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
    }

    public static int getTypeTag(Class<?> type) {
        if (type == ScriptRuntime.StringClass) {
            return 1;
        }
        if (type == ScriptRuntime.IntegerClass || type == Integer.TYPE) {
            return 2;
        }
        if (type == ScriptRuntime.BooleanClass || type == Boolean.TYPE) {
            return 3;
        }
        if (type == ScriptRuntime.DoubleClass || type == Double.TYPE) {
            return 4;
        }
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(type)) {
            return 5;
        }
        if (type == ScriptRuntime.ObjectClass) {
            return 6;
        }
        return 0;
    }

    public static Object convertArg(Context cx, Scriptable scope, Object arg, int typeTag) {
        switch (typeTag) {
            case 1: {
                if (arg instanceof String) {
                    return arg;
                }
                return ScriptRuntime.toString(arg);
            }
            case 2: {
                if (arg instanceof Integer) {
                    return arg;
                }
                return ScriptRuntime.toInt32(arg);
            }
            case 3: {
                if (arg instanceof Boolean) {
                    return arg;
                }
                return ScriptRuntime.toBoolean(arg) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                if (arg instanceof Double) {
                    return arg;
                }
                return new Double(ScriptRuntime.toNumber(arg));
            }
            case 5: {
                return ScriptRuntime.toObjectOrNull(cx, arg, scope);
            }
            case 6: {
                return arg;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getArity() {
        return this.parmsLength < 0 ? 1 : this.parmsLength;
    }

    @Override
    public int getLength() {
        return this.getArity();
    }

    @Override
    public String getFunctionName() {
        return this.functionName == null ? "" : this.functionName;
    }

    public Member getMethodOrConstructor() {
        if (this.member.isMethod()) {
            return this.member.method();
        }
        return this.member.ctor();
    }

    static Method findSingleMethod(Method[] methods2, String name) {
        Method found = null;
        int N = methods2.length;
        for (int i = 0; i != N; ++i) {
            Method method2 = methods2[i];
            if (method2 == null || !name.equals(method2.getName())) continue;
            if (found != null) {
                throw Context.reportRuntimeError2("msg.no.overload", name, method2.getDeclaringClass().getName());
            }
            found = method2;
        }
        return found;
    }

    static Method[] getMethodList(Class<?> clazz2) {
        Method[] methods2 = null;
        try {
            if (!sawSecurityException) {
                methods2 = clazz2.getDeclaredMethods();
            }
        }
        catch (SecurityException e) {
            sawSecurityException = true;
        }
        if (methods2 == null) {
            methods2 = clazz2.getMethods();
        }
        int count2 = 0;
        for (int i = 0; i < methods2.length; ++i) {
            if (sawSecurityException ? methods2[i].getDeclaringClass() != clazz2 : !Modifier.isPublic(methods2[i].getModifiers())) {
                methods2[i] = null;
                continue;
            }
            ++count2;
        }
        Method[] result2 = new Method[count2];
        int j = 0;
        for (int i = 0; i < methods2.length; ++i) {
            if (methods2[i] == null) continue;
            result2[j++] = methods2[i];
        }
        return result2;
    }

    public void addAsConstructor(Scriptable scope, Scriptable prototype) {
        this.initAsConstructor(scope, prototype);
        FunctionObject.defineProperty(scope, prototype.getClassName(), this, 2);
    }

    void initAsConstructor(Scriptable scope, Scriptable prototype) {
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
        this.setImmunePrototypeProperty(prototype);
        prototype.setParentScope(this);
        FunctionObject.defineProperty(prototype, "constructor", this, 7);
        this.setParentScope(scope);
    }

    public static Object convertArg(Context cx, Scriptable scope, Object arg, Class<?> desired) {
        int tag = FunctionObject.getTypeTag(desired);
        if (tag == 0) {
            throw Context.reportRuntimeError1("msg.cant.convert", desired.getName());
        }
        return FunctionObject.convertArg(cx, scope, arg, tag);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        Object result2;
        boolean checkMethodResult = false;
        int argsLength = args2.length;
        for (int i = 0; i < argsLength; ++i) {
            if (!(args2[i] instanceof ConsString)) continue;
            args2[i] = args2[i].toString();
        }
        if (this.parmsLength < 0) {
            if (this.parmsLength == -1) {
                Object[] invokeArgs = new Object[]{cx, thisObj, args2, this};
                result2 = this.member.invoke(null, invokeArgs);
                checkMethodResult = true;
            } else {
                boolean inNewExpr = thisObj == null;
                Boolean b = inNewExpr ? Boolean.TRUE : Boolean.FALSE;
                Object[] invokeArgs = new Object[]{cx, args2, this, b};
                result2 = this.member.isCtor() ? this.member.newInstance(invokeArgs) : this.member.invoke(null, invokeArgs);
            }
        } else {
            Object arg;
            int i;
            Object[] invokeArgs;
            Class<?> clazz2;
            if (!this.isStatic && !(clazz2 = this.member.getDeclaringClass()).isInstance(thisObj)) {
                Scriptable parentScope;
                boolean compatible = false;
                if (thisObj == scope && scope != (parentScope = this.getParentScope()) && (compatible = clazz2.isInstance(parentScope))) {
                    thisObj = parentScope;
                }
                if (!compatible) {
                    throw ScriptRuntime.typeError1("msg.incompat.call", this.functionName);
                }
            }
            if (this.parmsLength == argsLength) {
                invokeArgs = args2;
                for (i = 0; i != this.parmsLength; ++i) {
                    arg = args2[i];
                    Object converted = FunctionObject.convertArg(cx, scope, arg, this.typeTags[i]);
                    if (arg == converted) continue;
                    if (invokeArgs == args2) {
                        invokeArgs = (Object[])args2.clone();
                    }
                    invokeArgs[i] = converted;
                }
            } else if (this.parmsLength == 0) {
                invokeArgs = ScriptRuntime.emptyArgs;
            } else {
                invokeArgs = new Object[this.parmsLength];
                for (i = 0; i != this.parmsLength; ++i) {
                    arg = i < argsLength ? args2[i] : Undefined.instance;
                    invokeArgs[i] = FunctionObject.convertArg(cx, scope, arg, this.typeTags[i]);
                }
            }
            if (this.member.isMethod()) {
                result2 = this.member.invoke(thisObj, invokeArgs);
                checkMethodResult = true;
            } else {
                result2 = this.member.newInstance(invokeArgs);
            }
        }
        if (checkMethodResult) {
            if (this.hasVoidReturn) {
                result2 = Undefined.instance;
            } else if (this.returnTypeTag == 0) {
                result2 = cx.getWrapFactory().wrap(cx, scope, result2, null);
            }
        }
        return result2;
    }

    @Override
    public Scriptable createObject(Context cx, Scriptable scope) {
        Scriptable result2;
        if (this.member.isCtor() || this.parmsLength == -2) {
            return null;
        }
        try {
            result2 = (Scriptable)this.member.getDeclaringClass().newInstance();
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        result2.setPrototype(this.getClassPrototype());
        result2.setParentScope(this.getParentScope());
        return result2;
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.parmsLength > 0) {
            Class<?>[] types2 = this.member.argTypes;
            this.typeTags = new byte[this.parmsLength];
            for (int i = 0; i != this.parmsLength; ++i) {
                this.typeTags[i] = (byte)FunctionObject.getTypeTag(types2[i]);
            }
        }
        if (this.member.isMethod()) {
            Method method2 = this.member.method();
            Class<?> returnType = method2.getReturnType();
            if (returnType == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                this.returnTypeTag = FunctionObject.getTypeTag(returnType);
            }
        }
    }
}

